if SERVER then
 
    ORM_Cache = ORM_Cache or {}
    ORM_Cache.TTL = 60
    function ORM_Cache.init()
        if not file.Exists("orm_cache_data","DATA") then
            file.CreateDir("orm_cache_data","DATA")
        end
    end
    function ORM_Cache.get(steam_id)
        if not file.Exists("orm_cache_data/cache_"..steam_id..".json","DATA") then
            return null
        elseif file.Time("orm_cache_data/cache_"..steam_id..".json", "DATA") + ORM_Cache.TTL < os.time() then
            file.Delete("orm_cache_data/cache_"..steam_id..".json", "DATA")
            return null
        else
            return util.JSONToTable(file.Read("orm_cache_data/cache_"..steam_id..".json","DATA"))
        end
    end
    function ORM_Cache.set(steam_id, data)
        file.Write("orm_cache_data/cache_"..steam_id..".json", data)
    end
    local function kickWithReason(steamid, reason)
        game.KickID(util.SteamIDFrom64(steamid), "Заблокирован системой ОРМ по причине "..reason..". Подробнее на https://unitedmetrostroi.ru")
    end
    hook.Add("CheckPassword", "ORM_Ban_Chck_Passwd", function(steamid)
        ORM_Cache.init()
        local data = ORM_Cache.get(steamid)
        if data and data['result'] == true then
            kickWithReason(steamid, data['reason'])
        else
            http.Fetch("https://unitedmetrostroi.ru/api/check/"..steamid,
                function(body, length, headers, code)
                    if (code == 200) then
                        local data = util.JSONToTable(body)
                        ORM_Cache.set(steamid, util.TableToJSON(data))
                        if data['result'] == true then
                            kickWithReason(steamid, data['reason'])
                        end
                    end
                end
            )
        end
    end)
end